/*

***************************************************************************
Macro_Scripts File
Author:   Attila Szabo
Macro_Scripts that implement some of the Help menu items

Revision History
    Aug 06, 2003 - aszabo - Created
	
	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products
		consolidated the hotkey movie macro in this file

	23 march 2006, Pierre-Felix Breton
		added a new "data exchange solutions" menu
		consolidated with the welcome screen

	30th June 2006, Pierre-Felix Breton
		Added a check for 64 bit in the welcome screen to load a different web page
		reduces the margins of the welcome screen
		
	April 2006, Chris Johnson
		Removed activeX controls, and added .NET controls.

-- MODIFY THIS AT YOUR OWN RISK
***************************************************************************

*/

macroScript Help_Web_OnlineSupport
buttontext:~HELP_WEB_ONLINESUPPORT_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_ONLINESUPPORT_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_3DSMAX_SUPPORT~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_ONLINE_SUPPORT_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Updates
buttontext:~HELP_WEB_UPDATES_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_UPDATES_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_UPDATE~
	local strMsgTitle = "3ds Max"
	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_UPDATES_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Resources
buttontext:~HELP_WEB_RESOURCES_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_RESOURCES_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_RESOURCES~
	local strMsgTitle = "3ds Max"
	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_RESOURCES_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Training
buttontext:~HELP_WEB_TRAINING_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_TRAINING_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_TRAINING~
	local strMsgTitle = "3ds Max"
		
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_TRANING_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Partners
buttontext:~HELP_WEB_PARTNERS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_PARTNERS_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_DEVELOPERS~
	local strMsgTitle = "3ds Max"
        
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_PARTNERS_WEB_PAGE~
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)


macroScript Help_Web_ExchangeSolutions
buttontext:~HELP_WEB_EXCHANGESOLUTIONS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_EXCHANGESOLUTIONS_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_MAX_EXCHANGE~
	local strMsgTitle = "3ds Max"
        
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_DATA_EXCHANGE_SOLUTIONS_WEB_PAGE~
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)


macroScript HotkeyFlash 
category:~HELP_CATEGORY~ 
internalCategory:"Help"
tooltip:~HOTKEYFLASH_TOOLTIP~ 
(
--	rollout rHotkeyFlash ~HOTKEY_MAP_CAPTION~ height: 300 width: 600
--	( 
--		dotNetControl dnWeb "webbrowser" height: 300 width: 600 pos:[1,1,0]
--	 	on rHotkeyFlash open do
--		( 
--			dnWeb.ScrollBarsEnabled = false
--			local page = (getDir #maxroot) + "\\hotkeymap.html"
--			print page
--			h = dotnetobject "System.Uri" page
--			dnWeb.url = h
--		)
--	)
	on execute do
	(
		local langDir = (sysinfo.getMaxLanguage())[5]
		local page = (getDir #maxroot) + "\\" + langdir + "\\hotkeymap.html"
		ShellLaunch page ""
		--createDialog rHotkeyFlash escapeEnable:false
	)
)
macroScript Help_Web_LearningPath
buttontext:~HELP_WEB_LEARNINGPATH_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_LEARNINGPATH_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_3DSMAX_LEARNINGPATH~
	local strMsgTitle = "3ds Max"
        
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_LEARNING_PATH_WEB_PAGE~
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)


macroScript Help_Web_TheArea
buttontext:~HELP_WEB_THEAREA_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_THEAREA_TOOLTIP~ 
(
	local fname = ~FNAME_AREA_AUTODESK_COM2~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_AREA_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_HowTo_Movies
buttontext:~HELP_HOWTO_MOVIES_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_HOWTO_MOVIES_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_3DSMAX_HOWTO~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_HOW_TO_MOVIES_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)


macroScript Help_Certified_Graphic_Cards
buttontext:~HELP_CERTIFIED_GRAPHIC_CARDS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_CERTIFIED_GRAPHIC_CARDS_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_3DSMAX_CERTHARDWARE~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_CERTIFIED_HARDWARE_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Tutorials
buttontext:~HELP_TUTORIALS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_TUTORIALS_TOOLTIP~ 
(
	
	local fname = ~AUTODESK_COM_3DSMAX_TUTORIALS~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_TUTORIALS_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)


macroScript Help_Vegetation
buttontext:~HELP_VEGETATION_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_VEGETATION_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_SEEK_XFROG~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_VEGETATION_DOWNLOAD_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Student
buttontext:~HELP_STUDENT_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_STUDENT_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_EDCOMMUNITY~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_STUDENT_COMMUNITY_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_DefectSubmission
buttontext:~HELP_DEFECTSUBMISSION_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_DEFECTSUBMISSION_TOOLTIP~ 
(
	
	local fname = ~FNAME_AUTODESK_COM_3DSMAX_DEFECTSUBMIT~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_DEFECTSUBMISSION_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Feedback
buttontext:~HELP_WEB_FEEDBACK_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_FEEDBACK_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_FEEDBACK~
	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_FEEDBACK_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Facebook
buttontext:~HELP_WEB_FACEBOOK_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_FACEBOOK_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_FACEBOOK~

	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_FACEBOOK_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Area_Forums
buttontext:~HELP_WEB_AREA_FORUMS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_AREA_FORUMS_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_AREA_FORUMS~

	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_AREA_FORUMS_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_SAT
buttontext:~HELP_WEB_SAT_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_SAT_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_SAT~

	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_SAT_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Ideas
buttontext:~HELP_WEB_IDEAS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_IDEAS_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_IDEAS~

	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_IDEAS_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_3dsMax_Home
buttontext:~HELP_WEB_3DSMAX_HOME_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_3DSMAX_HOME_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_HOME~

	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_3DSMAX_HOME_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Try_Other
buttontext:~HELP_WEB_TRY_OTHER_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_TRY_OTHER_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_TRY_OTHER~

	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_TRY_OTHER_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Exchange_Apps 
buttontext:~HELP_WEB_EXCHANGE_APPS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_EXCHANGE_APPS_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_EXCHANGE_APPS~

	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_EXCHANGE_APPS_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Free_Learning_Resources
buttontext:~HELP_FREE_LEARNING_RES_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_FREE_LEARNING_RES_TOOLTIP~ 
(
	
	local fname = ~AUTODESK_COM_3DSMAX_FREE_LEARNING_RES~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_FREE_LEARNING_RES_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_FBX_Review
buttontext:~HELP_FBXREVIEW_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_FBXREVIEW_TOOLTIP~ 
(
	
	local fname = ~AUTODESK_COM_3DSMAX_FBXREVIEW~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_FBXREVIEW_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Pixlr
buttontext:~HELP_PIXLR_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_PIXLR_TOOLTIP~ 
(
	
	local fname = ~AUTODESK_COM_3DSMAX_PIXLR~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_PIXLR_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_123dapp
buttontext:~HELP_123DAPP_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_123DAPP_TOOLTIP~ 
(
	
	local fname = ~AUTODESK_COM_3DSMAX_123DAPP~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_123DAPP_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Character_Generator
buttontext:~HELP_CHARGEN_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_CHARGEN_TOOLTIP~ 
(
	
	local fname = ~AUTODESK_COM_3DSMAX_CHARGEN~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_CHARGEN_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Creative_Market
buttontext:~HELP_CREATIVE_MARKET_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_CREATIVE_MARKET_TOOLTIP~ 
(
	
	local fname = ~AUTODESK_COM_3DSMAX_CREATIVE_MARKET~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_CREATIVE_MARKET_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

-- END OF FILE
